
-- some common method, it does not depend on the other script files

function PxGrabRotations n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local quatlist = #()  
	for k in n.rotation.controller.keys do
	(
		slidertime = k.time
		append quatlist n.controller.rotation
	)
	slidertime = animationRange.start
	quatlist
)

function PxGrabPositions n =
(
	-- we might consider adding more slidertime samples later when our algo is more intelligent
	local poslist = #()  
	for k in n.position.controller.keys do
	(
		slidertime = k.time
		append poslist n.controller.position
	)
	slidertime = animationRange.start
	poslist
)

function PxCalcJointLimits n =
(
	quatlist = PxGrabRotations n
	if(quatlist.count <2) then
	(
		if PHYSX_AUTODESK_VER!=undefined then format "MassFX Warning: not enough keys to extract any useful info!\n" else
			format "PhysX Warning: not enough keys to extract any useful info!\n"
		[0,-45,45]; 
	)
	else
	(
		local r = quatlist[2] / quatlist[1]
		axis = r.axis
		cp  = cross r.axis [0,0,1] 
		cpb = cross r.axis [0,1,0] 
		if(length(cpb)>length(cp)) then
		(
			cp = cpb
		)
		nrml = normalize ( cp )
		
		slidertime = animationRange.start;
		--axis = getpoint3prop n "pmljointaxis" 
		--nrml = getpoint3prop n "pmljointnrml"
		--format "axis = %, normal = %\n" axis nrml
		na = nrml
		nloc = nrml * (conjugate(quatlist[1]) as Matrix3) 
		local limithigh=0
		local limitlow=0
		local theta=0;
		local q
		for q in quatlist do
		(
			nb = nloc *(q as Matrix3) 
			dp = dot na nb 
			if(dp> 1.0) then dp =  1.0 ;
			if(dp<-1.0) then dp = -1.0 ;
			delta = acos(dp)
			cp = cross na nb ;
			if((dot axis cp) <0) then
			(
				delta = -delta;
			)
			theta = theta + delta
			if(theta > limithigh) then 
			(
				limithigh = theta
			)
			if(theta < limitlow) then 
			(
				limitlow = theta
			)
			na = nb;
		)
		
		--format "axis = %, normal = %, limitlow = %, limithigh = %\n" axis nrml limitlow limithigh
		slidertime = animationRange.start;
		if(limithigh-limitlow > 315) then
		(
			[0,limitlow,limithigh]
		)
		else [1,limitlow,limithigh]
	)
)

-- Sorted set of items, supports union and intersection operations
struct SortedArray_Struct
(
	itemArray = #(),
	
	fn DefaultComparator a b =
	(
		if a > b then 1
		else if a < b then -1
		else 0
	),
	comparator = DefaultComparator,	
	
	fn FindIndex item findExisting:true =
	(	-- Binary search.  Returns index where item should be inserted, or existing item if findExisting==true
		local len = itemArray.count
		local lo = 1, hi = len, cur = 1, exists = false
		while lo<=hi do
		(
			cur = (lo + ((hi-lo)/2))
			local res = Comparator item itemArray[cur]
			if res==0 then ( exists = true; lo=(hi+1) ) -- force loop to break
			else if res<0 then hi=(cur-1)
		else if res>0 then lo=cur=(cur+1)
		)
		if (findExisting) and (not exists) then 0
		else cur
	),
	fn AddItem item = 
	(
		local index = FindIndex item findExisting:false
		insertItem item itemArray index
	),
	fn SetUnion itemArrayInput =
	(
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do AddItem item
	),
	fn SetIntersection itemArrayInput =
	(
		b = #{} -- BitArray, all values initially false
		if (isKindOf itemArrayInput SortedArray_Struct) then itemArrayInput = itemArrayInput.itemArray
		for item in itemArrayInput do
		(
			local index = FindIndex item findExisting:false
			if (itemArray[index]==item) then b[index] = true
		)
		for index = itemArray.count to 1 by -1 do
		(
			if not b[index] then deleteItem itemArray index
		)
	),

	fn Init itemArrayInput comparator:undefined =
	(
		itemArray = #()
		if (comparator!=undefined) then this.comparator = comparator
		SetUnion itemArrayInput
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBPmQ86TXdYaj4hcPxfL+qvyscNirjmLuiY
-- 3fMFVCXbbbVu0cf9bwmIZMfq1HPqWPgJvSbe7Eik3Tokl/gWk9vJbU35ptMAoz/M
-- DEYZJCDBufQG2w+BAIIWdQruUfRI5J/O6H/Y/i5Z0QzcU+hm/BtmpC0nGlW14lX2
-- kbHRSgU8WYWMe31M8d9FiDL+NxXcfqIymXVTq8ZA8k2lm7eb1VhZEGbCu4Dh/x29
-- bI4nZko6noB9VBPN0FIvSzPt+ccaPrpwl1Pql07HUXb3VDyEbPDCgGsUrUgf9nWr
-- Skou6Q9k9rWdgBieFPzzAzyCjKjwSttQ57QEzVdknSpzMfC7tYHj
-- -----END-SIGNATURE-----